//=============================================================================

/*:
 * @plugindesc オプションの音量変更の区切りを変更します。
 * 
 * @author LefTonbo
 *
 * @param Option Volume Offset
 * @type number
 * @desc 1変更あたりに変更されるボリューム値
 * デフォルト値: 20
 * @default 20
 *
 */

//=============================================================================

var Imported = Imported || {};
Imported.LP_OptionVolumeOffset = true;

var LeftPlugin = LeftPlugin || {};

LeftPlugin.Parameters = PluginManager.parameters('LP_OptionVolumeOffset');
LeftPlugin.Param = LeftPlugin.Param || {};

LeftPlugin.Param.OptionVolumeOffset = Number(LeftPlugin.Parameters['Option Volume Offset']);

//=============================================================================

(function() {

//=============================================================================
// Window_Options
//=============================================================================

Window_Options.prototype.volumeOffset = function() {
    return LeftPlugin.Param.OptionVolumeOffset;
};

//=============================================================================

})();

// EOF